<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.6.0
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2025 KONKORD DIGITAL
 */

namespace Modules\Deals\Tests\Feature;

use Modules\Core\Tests\ResourceTestCase;
use Modules\Deals\Enums\DealStatus;

class MarkAsOpenTest extends ResourceTestCase
{
    protected $action = 'mark-as-open';

    protected $resourceName = 'deals';

    public function test_super_admin_user_can_run_deal_mark_as_open_action(): void
    {
        $this->signIn();
        $deal = $this->factory()->won()->create();

        $this->runAction($this->action, $deal)->assertActionOk();
        $this->assertSame(DealStatus::open, $deal->fresh()->status);
    }

    public function test_authorized_user_can_run_deal_mark_as_open_action(): void
    {
        $this->asRegularUser()->withPermissionsTo('edit all deals')->signIn();

        $user = $this->createUser();
        $deal = $this->factory()->won()->for($user)->create();

        $this->runAction($this->action, $deal)->assertActionOk();
        $this->assertSame(DealStatus::open, $deal->fresh()->status);
    }

    public function test_unauthorized_user_can_run_deal_mark_as_open_action_on_own_deal(): void
    {
        $signedInUser = $this->asRegularUser()->withPermissionsTo('edit own deals')->signIn();

        $dealForSignedIn = $this->factory()->won()->for($signedInUser)->create();
        $otherDeal = $this->factory()->won()->create();

        $this->runAction($this->action, $otherDeal)->assertActionUnauthorized();
        $this->runAction($this->action, $dealForSignedIn);
        $this->assertSame(DealStatus::open, $dealForSignedIn->fresh()->status);
    }
}
