<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* PayloadBrand File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* PayloadBrand class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class PayloadBrand extends Enum
{
    /**
    * The Enum PayloadBrand
    */
    const UNKNOWN = "unknown";
    const OTHER = "other";
    const AMERICAN_EXPRESS = "americanExpress";
    const CAPITAL_ONE = "capitalOne";
    const DHL = "dhl";
    const DOCU_SIGN = "docuSign";
    const DROPBOX = "dropbox";
    const FACEBOOK = "facebook";
    const FIRST_AMERICAN = "firstAmerican";
    const MICROSOFT = "microsoft";
    const NETFLIX = "netflix";
    const SCOTIABANK = "scotiabank";
    const SEND_GRID = "sendGrid";
    const STEWART_TITLE = "stewartTitle";
    const TESCO = "tesco";
    const WELLS_FARGO = "wellsFargo";
    const SYRINX_CLOUD = "syrinxCloud";
    const ADOBE = "adobe";
    const TEAMS = "teams";
    const ZOOM = "zoom";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
}
